PSCAD 4.2.0

Settings
 {
 Id = "976141504.1144441418"
 Author = "jayas.jayas"
 Desc = "Single Transmission Line (Mid-line Fault)"
 Arch = "windows"
 Options = 0
 Build = 19
 Warn = 7
 Check = 15
 Libs = ""
 Source = ""
 RunInfo = 
  {
  Fin = 0.5
  Step = 5e-005
  Plot = 5e-005
  Chat = 0.001
  Brch = 0.0005
  Lat = 100
  Options = 0
  Advanced = 511
  Debug = 0
  StartFile = ""
  OFile = "noname.out"
  SFile = "noname.snp"
  SnapTime = 0.3
  Mruns = 10
  Mrunfile = 0
  StartType = 0
  PlotType = 0
  SnapType = 0
  MrunType = "mrun"
  }


Global_Consts = 
  {
  f = 60.0 [Hz]
  }

 }

Definitions
 {
 Module("Controls")
  {
  Desc = ""
  FileDate = 1144441328
  Nodes = 
   {
   Input("FType",36,-18)
    {
    Type = Integer
    }
   Output("F",36,18)
    {
    Type = Integer
    }
   Output("B",36,-36)
    {
    Type = Integer
    Dim  = [2]
    }
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Pen(Gray)
   Line(27,28,27,-43)
   Brush(,Silver)
   Rectangle(0,-13,3,0)
   Brush(,Gray)
   Rectangle(-3,-10,6,-7)
   Text(1,25,"Controls")
   Pen(Black)
   Line(27,18,36,18)
   Line(27,-36,36,-36)
   Pen(ByNode)
   Brush(Hollow)
   Rectangle(-4,-18,7,3)
   Pen(Black)
   Line(27,-18,36,-18)
   }


  Page(A/A4,Landscape,16,[597,467],100)
   {
   -Sticky-([18,180],0)
    {
    Name = ""
    Font = 1
    Bounds = 18,180,144,216
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "PREFAULT CONTROLS"
    }
   -Sticky-([72,666],0)
    {
    Name = ""
    Font = 1
    Bounds = 72,666,180,702
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "FAULT CONTROLS"
    }
   -ControlPanel-([72,720],0)
    {
    Name = "Fault Location, Type, Start & Duration"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,432,126
    Dial(40588176)
    Dial(40646784)
    Slider(40232272)
    Slider(40234496)
    Slider(40601488)
    }
   -Wire-([1116,864],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.datamerge([1044,1098],4,0,180)
    {
    N = "2"
    Type = "1"
    Disp = "1"
    }
   0.datalabel([1026,1026],6,0,-1)
    {
    Name = "B1"
    }
   0.datalabel([1026,1044],6,0,-1)
    {
    Name = "B2"
    }
   0.datalabel([990,684],3,0,-1)
    {
    Name = "B1T1"
    }
   0.datalabel([990,738],3,0,-1)
    {
    Name = "B1T2"
    }
   0.datalabel([990,792],3,0,-1)
    {
    Name = "B2T1"
    }
   0.var([954,684],0,39767280,20)
    {
    Name = "B1 T1"
    Group = ""
    Display = "0"
    Max = "2"
    Min = "0.0"
    Value = "0.35"
    Units = "s"
    Collect = "1"
    }
   0.var([954,738],0,39768712,40)
    {
    Name = "B1 T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "0.4"
    Units = "s"
    Collect = "1"
    }
   0.var([954,792],0,39770688,50)
    {
    Name = "B2 T1"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "0.35"
    Units = "s"
    Collect = "1"
    }
   -Sticky-([954,198],0)
    {
    Name = ""
    Font = 1
    Bounds = 954,198,1062,234
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "BREAKER CONTROLS"
    }
   -Wire-([1116,684],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.datalabel([990,846],3,0,-1)
    {
    Name = "B2T2"
    }
   0.tbreakn([1062,684],4,0,110)
    {
    NUMS = "2"
    INIT = "0"
    TO1 = "B1T1"
    TO2 = "B1T2"
    }
   -ControlPanel-([954,252],0)
    {
    Name = "B1 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(40192872)
    Slider(39767280)
    Slider(39768712)
    }
   -Wire-([630,756],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([666,756],0,0,-1)
    {
    Name = "Tfs"
    }
   -Wire-([630,828],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([666,828],0,0,-1)
    {
    Name = "Tfd"
    }
   0.datalabel([792,792],4,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([990,1134],4,0,-1)
    {
    Name = "Fault"
    }
   -Wire-([990,1134],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.var([954,846],0,40169080,80)
    {
    Name = "B2 T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "0.4"
    Units = "s"
    Collect = "1"
    }
   -ControlPanel-([954,396],0)
    {
    Name = "B2 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(40196280)
    Slider(39770688)
    Slider(40169080)
    }
   0.tbreakn([1062,864],4,0,90)
    {
    NUMS = "2"
    INIT = "0"
    TO1 = "B2T1"
    TO2 = "B2T2"
    }
   -Wire-([1116,720],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   0.logic([1152,864],6,0,150)
    {
    Type = "1"
    Inv = "0"
    }
   0.datalabel([1080,774],0,0,-1)
    {
    Name = "FType"
    }
   -Wire-([1080,774],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.import([1080,1188],0,0,100)
    {
    Name = "FType"
    }
   0.logic([1152,684],0,0,120)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([1188,684],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.var_switch([1188,648],0,40192872,10)
    {
    Name = "42-B1"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   0.datalabel([1296,684],4,0,-1)
    {
    Name = "B1"
    }
   -Wire-([1188,864],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Sticky-([972,954],0)
    {
    Name = ""
    Font = 1
    Bounds = 972,954,1080,990
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Exports to Main Page"
    }
   -Sticky-([954,558],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 954,558,1116,630
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Adjust breaker clearing time (T1)
and reclose time (T2) if needed."
    }
   0.var_switch([1188,810],6,40196280,70)
    {
    Name = "42-B2"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   -Wire-([1224,828],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   0.datalabel([1296,828],2,0,-1)
    {
    Name = "B2"
    }
   0.logic([1260,828],0,0,160)
    {
    Type = "2"
    Inv = "0"
    }
   0.logic([1260,684],6,0,130)
    {
    Type = "2"
    Inv = "0"
    }
   0.export([1080,1080],4,0,190)
    {
    Name = "B"
    }
   0.tfaultn([756,792],4,0,140)
    {
    TF = "Tfs"
    DF = "Tfd"
    }
   -Sticky-([486,126],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 486,126,666,216
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Adjust phase angle to obtain
the correct power flow. Adjust
voltage to obtain the matching
VAR flow at each end."
    }
   0.arrow_a([486,216],1,0,-1)
    {
    }
   -ControlPanel-([18,396],0)
    {
    Name = "SOURCE 2"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,504,126
    Slider(40592416)
    Meter(40642800)
    Meter(40644792)
    Slider(40595408)
    Meter(40565264)
    Meter(40634600)
    Meter(40636688)
    }
   0.var([594,756],0,40232272,30)
    {
    Name = "Fault Start "
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.22"
    Units = "s"
    Collect = "1"
    }
   0.var([594,828],0,40234496,60)
    {
    Name = "Duration "
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.15"
    Units = ""
    Collect = "1"
    }
   -Sticky-([270,864],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 270,864,396,1080
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Dial Position:
  1=> A-g
  2=> B-g
  3=> C-g
  4=> AB-g
  5=> AC-g
  6=> BC-g
  7=> ABC-g
  8=> AB 
  9=> AC 
10=> No Fault (0)
11=> No fault  (0)"
    }
   -Sticky-([738,108],0)
    {
    Name = ""
    Font = 1
    Bounds = 738,108,846,144
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Playback Recorders"
    }
   -Sticky-([738,450],0)
    {
    Name = ""
    Font = 1
    Bounds = 738,450,918,594
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
To turn the Recorders on, 
click on the switch.
On = Recorder will record data.
Off = Recorder will NOT 
          record data.

You can turn on or off
each recorder individually."
    }
   -ControlPanel-([756,306],0)
    {
    Name = "Recorder Control"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,144,126
    Switch(40659328)
    Switch(40661072)
    }
   -ControlPanel-([756,180],0)
    {
    Name = "Recorders"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,144,126
    Slider(40654872)
    Slider(40558032)
    }
   0.export([1080,1134],4,0,170)
    {
    Name = "F"
    }
   -Sticky-([72,864],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 72,864,234,1116
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Dial Position:
  1=> FT1:
          Between Source
          and  B1
  2=> FT2:
          Between Line1
          and  B1
  3=> FT3:
          Midpoint on Line1
  4=> FT4:
          Between Line1
          and B2
  5=> FT5:
          Between Source
          and B2"
    }
   -ControlPanel-([18,252],0)
    {
    Name = "SOURCE 1"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,504,126
    Slider(40597392)
    Meter(40638680)
    Meter(40640808)
    Slider(40599504)
    Meter(40666184)
    Meter(40630792)
    Meter(40632608)
    }
   -Divider-([18,612],0)
    {
    Size(918,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([936,72],0)
    {
    Size(0,1080)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([702,54],0)
    {
    Size(0,558)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   }
  }
 Module("Plots")
  {
  Desc = ""
  FileDate = 0
  Nodes = 
   {
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Line(-13,-1,-13,-21)
   Line(-18,-4,21,-4)
   Line(-13,-4,-4,-13)
   Line(-4,-13,1,-10)
   Line(6,-16,12,-13)
   Pen(Gray)
   Line(27,28,27,-43)
   Pen(Black)
   Line(1,-10,6,-16)
   Text(1,-28,"Plots")
   }


  Page(A/A4,Landscape,16,[597,467],100)
   {
   -Plot-([144,90],0)
    {
    Title = "Plots at B1"
    Draw = 1
    Area = [0,0,630,1044]
    Posn = [144,90]
    Icon = [-1,-1]
    Extents = 0,0,630,1044
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,630,250],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(40563272,"V1a",0,,,)
     Curve(40515400,"V1b",1,,,)
     Curve(40495680,"V1c",2,,,)
     }
    Graph([0,250],[0,0,630,250],"Current")
     {
     Options = 9
     Units = ""
     Curve(40561280,"I1a",0,,,)
     Curve(40521200,"I1b",1,,,)
     Curve(40572976,"I1c",2,,,)
     }
    Graph([0,500],[0,0,630,250],"Current")
     {
     Options = 9
     Units = ""
     Curve(40578032,"I10",0,,,)
     }
    PGraph([0,750],[0,0,630,231],"PolyGraph")
     {
     Options = 2
     Curve(40508448,"Br1a",0,,,1)
     Curve(40517392,"Br1b",1,,,1)
     Curve(40555336,"Br1c",2,,,1)
     }
    }
   -Plot-([810,90],0)
    {
    Title = "Plots at B2"
    Draw = 1
    Area = [0,0,630,1044]
    Posn = [810,90]
    Icon = [-1,-1]
    Extents = 0,0,630,1044
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,630,250],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(40497672,"V2a",0,,,)
     Curve(40504800,"V2b",1,,,)
     Curve(40533096,"V2c",2,,,)
     }
    Graph([0,250],[0,0,630,250],"Current")
     {
     Options = 9
     Units = ""
     Curve(40491776,"I2a",0,,,)
     Curve(40493640,"I2b",1,,,)
     Curve(40574968,"I2c",2,,,)
     }
    Graph([0,500],[0,0,630,250],"Current")
     {
     Options = 9
     Units = ""
     Curve(40580696,"I20",0,,,)
     }
    PGraph([0,750],[0,0,630,231],"PolyGraph")
     {
     Options = 2
     Curve(40511456,"Br2a",0,,,1)
     Curve(40519296,"Br2b",1,,,1)
     Curve(40513496,"Br2c",2,,,1)
     }
    }
   }
  }
 Module("Main")
  {
  Desc = "Main Page"
  FileDate = 0
  Nodes = 
   {
   }

  Graphics = 
   {
   Rectangle(-18,-18,18,18)
   }


  Page(B/A3,Landscape,16,[597,467],100)
   {
   0.datalabel([522,648],0,0,-1)
    {
    Name = "FT2"
    }
   -Wire-([324,522],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   -Wire-([846,522],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   -Wire-([1026,522],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   0.datalabel([990,1440],0,0,-1)
    {
    Name = "I1A"
    }
   0.datalabel([990,1476],0,0,-1)
    {
    Name = "I1B"
    }
   0.datalabel([990,1512],0,0,-1)
    {
    Name = "I1C"
    }
   0.datalabel([1116,1440],0,0,-1)
    {
    Name = "I2A"
    }
   0.datalabel([1116,1476],0,0,-1)
    {
    Name = "I2B"
    }
   0.pgb([1152,1440],0,40491776,840)
    {
    Name = "I2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-4.0"
    Max = "4.0"
    }
   0.pgb([1152,1476],0,40493640,760)
    {
    Name = "I2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-4.0"
    Max = "4.0"
    }
   0.pgb([1026,1386],0,40495680,380)
    {
    Name = "V1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.pgb([1152,1314],0,40497672,290)
    {
    Name = "V2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.pgb([1152,1350],0,40504800,350)
    {
    Name = "V2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.datalabel([1278,1314],0,0,-1)
    {
    Name = "Br1A"
    }
   0.datalabel([1278,1350],0,0,-1)
    {
    Name = "Br1B"
    }
   0.datalabel([1278,1386],0,0,-1)
    {
    Name = "Br1C"
    }
   0.pgb([1314,1314],0,40508448,930)
    {
    Name = "Br1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.datalabel([1404,1314],0,0,-1)
    {
    Name = "Br2A"
    }
   0.datalabel([1404,1350],0,0,-1)
    {
    Name = "Br2B"
    }
   0.pgb([1440,1314],0,40511456,920)
    {
    Name = "Br2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.pgb([1440,1386],0,40513496,870)
    {
    Name = "Br2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.pgb([1026,1350],0,40515400,330)
    {
    Name = "V1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.pgb([1314,1350],0,40517392,910)
    {
    Name = "Br1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.pgb([1440,1350],0,40519296,900)
    {
    Name = "Br2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.pgb([1026,1476],0,40521200,780)
    {
    Name = "I1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-4.0"
    Max = "4.0"
    }
   0.datalabel([540,1206],2,0,-1)
    {
    Name = "I1A"
    }
   0.datalabel([576,1206],2,0,-1)
    {
    Name = "I1B"
    }
   0.datalabel([612,1206],2,0,-1)
    {
    Name = "I1C"
    }
   0.datalabel([540,1386],2,0,-1)
    {
    Name = "I2A"
    }
   0.datalabel([576,1386],2,0,-1)
    {
    Name = "I2B"
    }
   0.datalabel([612,1386],2,0,-1)
    {
    Name = "I2C"
    }
   0.datalabel([990,1314],2,0,-1)
    {
    Name = "V1A"
    }
   0.datalabel([990,1350],2,0,-1)
    {
    Name = "V1B"
    }
   0.datalabel([1116,1350],2,0,-1)
    {
    Name = "V2B"
    }
   0.datalabel([432,1206],2,0,-1)
    {
    Name = "V1A"
    }
   0.datalabel([468,1206],2,0,-1)
    {
    Name = "V1B"
    }
   0.datalabel([504,1206],2,0,-1)
    {
    Name = "V1C"
    }
   0.datalabel([432,1386],6,0,-1)
    {
    Name = "V2A"
    }
   0.datalabel([468,1386],6,0,-1)
    {
    Name = "V2B"
    }
   0.datalabel([504,1386],6,0,-1)
    {
    Name = "V2C"
    }
   -Wire-([378,522],0,0,-1)
    {
    Vertex="0,0;-108,0"
    }
   -Wire-([360,1458],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([378,1314],0,0,-1)
    {
    Vertex="0,0;0,180"
    }
   -Wire-([342,1278],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.pgb([1152,1386],0,40533096,400)
    {
    Name = "V2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   -Wire-([1278,1512],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1278,1512],0,0,-1)
    {
    Name = "S1W"
    }
   -Wire-([1278,1548],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1278,1548],0,0,-1)
    {
    Name = "S1Q"
    }
   -Wire-([1404,1512],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1404,1548],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1404,1548],0,0,-1)
    {
    Name = "S2Q"
    }
   0.datalabel([1116,1314],2,0,-1)
    {
    Name = "V2A"
    }
   0.datalabel([1404,1512],0,0,-1)
    {
    Name = "S2W"
    }
   -Wire-([1404,1476],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1404,1476],0,0,-1)
    {
    Name = "Q2"
    }
   -Wire-([1404,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1404,1440],0,0,-1)
    {
    Name = "P2"
    }
   -Wire-([1404,1386],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1404,1350],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1404,1314],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1404,1386],0,0,-1)
    {
    Name = "Br2C"
    }
   0.datalabel([1116,1512],0,0,-1)
    {
    Name = "I2C"
    }
   -Wire-([1116,1512],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1116,1476],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1116,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([990,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([990,1476],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([990,1512],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1278,1314],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1278,1350],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1278,1386],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1278,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1278,1476],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1116,1386],2,0,-1)
    {
    Name = "V2C"
    }
   0.datatap([1098,1386],0,0,390)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1098,1350],0,0,340)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1098,1314],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1098,1350],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1098,1386],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([990,1386],2,0,-1)
    {
    Name = "V1C"
    }
   -Wire-([972,1386],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([972,1350],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([972,1314],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([1278,1476],0,0,-1)
    {
    Name = "Q1"
    }
   0.pgb([1314,1386],0,40555336,880)
    {
    Name = "Br1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.datatap([1098,1314],0,0,270)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1080,1278],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.var([306,1314],0,40558032,200)
    {
    Name = "Stop"
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.5"
    Units = "s"
    Collect = "1"
    }
   0.datatap([1386,1008],2,0,510)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1386,1008],6,0,-1)
    {
    Name = "B2"
    }
   0.pgb([1026,1440],0,40561280,860)
    {
    Name = "I1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-4.0"
    Max = "4.0"
    }
   0.pgb([1026,1314],0,40563272,250)
    {
    Name = "V1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.pgb([1440,1260],0,40565264,230)
    {
    Name = "V2rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   0.datatap([1350,1008],2,0,480)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([342,648],0,0,-1)
    {
    Name = "FT1"
    }
   0.datalabel([756,1224],2,0,-1)
    {
    Name = "FT1"
    }
   0.datalabel([792,1224],2,0,-1)
    {
    Name = "FT2"
    }
   0.datalabel([342,666],0,0,-1)
    {
    Name = "F1"
    }
   0.datalabel([756,1476],0,0,-1)
    {
    Name = "F1"
    }
   0.datalabel([1350,1008],6,0,-1)
    {
    Name = "B1"
    }
   0.datalabel([1368,1080],4,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([810,1386],2,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([522,666],0,0,-1)
    {
    Name = "F2"
    }
   0.pgb([1026,1512],0,40572976,740)
    {
    Name = "I1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-4.0"
    Max = "4.0"
    }
   0.pgb([1152,1512],0,40574968,720)
    {
    Name = "I2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-4.0"
    Max = "4.0"
    }
   -Wire-([1116,1548],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([990,1548],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([990,1548],0,0,-1)
    {
    Name = "I10"
    }
   0.pgb([1026,1548],0,40578032,700)
    {
    Name = "I10"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.5"
    Max = "1.5"
    }
   0.datalabel([1116,1548],0,0,-1)
    {
    Name = "I20"
    }
   0.pgb([1152,1548],0,40580696,680)
    {
    Name = "I20"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.5"
    Max = "1.5"
    }
   0.datatap([756,1224],6,0,1000)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([828,1224],6,0,980)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([864,1224],6,0,970)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([828,1224],2,0,-1)
    {
    Name = "FT3"
    }
   0.datatap([756,1476],0,0,850)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([828,1476],0,0,820)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([792,1476],0,0,-1)
    {
    Name = "F2"
    }
   0.datatap([792,1476],0,0,830)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([828,1476],0,0,-1)
    {
    Name = "F3"
    }
   0.var_pot([702,1350],0,40588176,260)
    {
    Name = "Fault location"
    Group = ""
    Display = "0"
    NDP = "5"
    Value = "1"
    F1 = "1.0"
    F2 = "2.0"
    F3 = "3.0"
    F4 = "4.0"
    F5 = "5.0"
    F6 = "6.0"
    F7 = "7.0"
    F8 = "8.0"
    F9 = "9.0"
    F10 = "10.0"
    }
   0.unity([774,1350],0,0,280)
    {
    IType = "2"
    OType = "1"
    }
   0.unity([810,1350],4,0,460)
    {
    IType = "2"
    OType = "1"
    }
   -Wire-([774,1314],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Wire-([810,1314],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.datalabel([810,1350],5,0,-1)
    {
    Name = "FType"
    }
   0.var([1098,594],5,40592416,50)
    {
    Name = "Ph Angle"
    Group = "SS2"
    Display = "0"
    Max = "180"
    Min = "0"
    Value = "20.0"
    Units = "deg"
    Collect = "1"
    }
   0.var([1152,594],5,40595408,60)
    {
    Name = "Voltage"
    Group = "SS2"
    Display = "0"
    Max = "500"
    Min = "0.0"
    Value = "230.0"
    Units = "kV"
    Collect = "1"
    }
   0.var([252,594],3,40597392,40)
    {
    Name = "Ph Angle"
    Group = "SS1"
    Display = "0"
    Max = "180"
    Min = "0.0"
    Value = "0.0"
    Units = "deg"
    Collect = "1"
    }
   0.var([198,594],3,40599504,30)
    {
    Name = "Voltage"
    Group = "SS1"
    Display = "0"
    Max = "500"
    Min = "0.0"
    Value = "230.0"
    Units = "kV"
    Collect = "1"
    }
   0.var([738,1548],0,40601488,410)
    {
    Name = "Rf"
    Group = ""
    Display = "0"
    Max = "50"
    Min = "0.001"
    Value = "0.001"
    Units = "ohm"
    Collect = "1"
    }
   -Sticky-([936,1188],0)
    {
    Name = ""
    Font = 1
    Bounds = 936,1188,1044,1224
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "OUTPUT CHANNELS"
    }
   0.recorder2_0([504,1458],0,0,890)
    {
    FName = "stn2"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "2"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V2a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V2b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V2c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I2a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I2b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I2c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.datalabel([612,1350],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([612,1530],0,0,-1)
    {
    Name = "Fault"
    }
   0.annotation([738,1530],0,0,-1)
    {
    AL1 = "Rf"
    AL2 = ""
    }
   0.datalabel([1080,1278],2,0,-1)
    {
    Name = "V2"
    }
   -Wire-([954,1278],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datatap([972,1314],0,0,240)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([954,1278],2,0,-1)
    {
    Name = "V1"
    }
   0.datatap([972,1386],0,0,370)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([972,1350],0,0,320)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.tpflt([306,630],0,0,1110)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   -Wire-([774,1548],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([828,1548],0,0,-1)
    {
    Name = "Ron"
    }
   0.tpflt([864,630],4,0,1080)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.datalabel([828,666],0,0,-1)
    {
    Name = "F4"
    }
   0.datalabel([828,648],0,0,-1)
    {
    Name = "FT4"
    }
   0.datalabel([1008,666],0,0,-1)
    {
    Name = "F5"
    }
   0.tpflt([1044,630],4,0,1060)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.datalabel([1008,648],0,0,-1)
    {
    Name = "FT5"
    }
   0.mux_array([792,1278],0,0,940)
    {
    DPath = "0"
    }
   -Wire-([738,1242],0,0,-1)
    {
    Vertex="0,0;144,0"
    }
   0.datatap([792,1224],6,0,990)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([900,1224],6,0,960)
    {
    Index = "5"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([864,1224],2,0,-1)
    {
    Name = "FT4"
    }
   0.datalabel([900,1224],2,0,-1)
    {
    Name = "FT5"
    }
   0.mux_array([792,1422],6,0,500)
    {
    DPath = "0"
    }
   0.datatap([864,1476],0,0,810)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   -Wire-([738,1458],0,0,-1)
    {
    Vertex="0,0;144,0"
    }
   0.datatap([900,1476],0,0,800)
    {
    Index = "5"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([864,1476],0,0,-1)
    {
    Name = "F4"
    }
   0.datalabel([900,1476],0,0,-1)
    {
    Name = "F5"
    }
   0.datalabel([1278,1440],0,0,-1)
    {
    Name = "P1"
    }
   0.pgb([1314,1440],0,40630792,790)
    {
    Name = "P1"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   0.pgb([1314,1476],0,40632608,750)
    {
    Name = "Q1"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   0.pgb([1440,1440],0,40634600,770)
    {
    Name = "P2"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   0.pgb([1440,1476],0,40636688,730)
    {
    Name = "Q2"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   0.pgb([1314,1512],0,40638680,710)
    {
    Name = "S1W"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   0.pgb([1314,1548],0,40640808,670)
    {
    Name = "S1Q"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   0.pgb([1440,1512],0,40642800,690)
    {
    Name = "S2W"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   0.pgb([1440,1548],0,40644792,660)
    {
    Name = "S2Q"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   0.var_pot([882,1350],2,40646784,310)
    {
    Name = "Fault Type"
    Group = ""
    Display = "0"
    NDP = "10"
    Value = "1"
    F1 = "1.0"
    F2 = "2.0"
    F3 = "3.0"
    F4 = "4.0"
    F5 = "5.0"
    F6 = "6.0"
    F7 = "7.0"
    F8 = "8.0"
    F9 = "9.0"
    F10 = "0"
    }
   0.recorder2_0([504,1278],0,0,950)
    {
    FName = "stn1"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "1"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V1a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V1b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V1c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I1a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I1b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I1c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.const([126,1242],1,0,180)
    {
    Name = ""
    Value = "10.0"
    }
   0.select([162,1278],6,0,450)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   0.const([108,1422],1,0,300)
    {
    Name = ""
    Value = "10.0"
    }
   0.var([18,1314],0,40654872,190)
    {
    Name = "Start"
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.15"
    Units = "s"
    Collect = "1"
    }
   -Wire-([360,1278],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   0.select([144,1458],6,0,360)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   -Wire-([360,1458],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   -Wire-([54,1494],0,0,-1)
    {
    Vertex="0,0;0,-180"
    }
   -Wire-([378,1494],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([342,1314],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([54,1314],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([54,1494],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.var_switch([162,1206],1,40659328,170)
    {
    Name = "en Record1"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.var_switch([144,1386],1,40661072,220)
    {
    Name = "en Record2"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.datalabel([1368,1044],2,0,-1)
    {
    Name = "FType"
    }
   -Wire-([1368,1026],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([1440,1044],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   -Wire-([1440,1080],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   0.breaker3([936,522],0,0,530)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B2"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I2A"
    IBRB = "I2B"
    IBRC = "I2C"
    IBR0 = "I20"
    SBRA = "Br2A"
    SBRB = "Br2B"
    SBRC = "Br2C"
    BP = "P2"
    BQ = "Q2"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "1.807 [MW]"
    Q = "-0.4333 [MVAR]"
    }
   -Wire-([972,522],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   0.pgb([1314,1260],0,40666184,210)
    {
    Name = "V1rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   0.source3R([234,522],6,0,420)
    {
    Name = "Source1"
    MVA = "100.0 [MVA]"
    Vm = "230.0 [kV]"
    F = "$(f)"
    Tc = "0.05 [s]"
    Ideal = "0"
    ZSeq = "1"
    Imp = "1"
    View = "1"
    details = "1"
    Z1 = "52.9 [ohm]"
    Phi1 = "80.0 [deg]"
    R1p = "1.0 [ohm]"
    X1p = "0.1 [ohm]"
    Z0 = "52.9 [ohm]"
    Phi0 = "80.0 [deg]"
    R0p = "1.0 [ohm]"
    X0p = "0.1 [ohm]"
    P = "S1W"
    Q = "S1Q"
    Ia = ""
    Ib = ""
    Ic = ""
    }
   0.breaker3([414,522],4,0,490)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B1"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I1A"
    IBRB = "I1B"
    IBRC = "I1C"
    IBR0 = "I10"
    SBRA = "Br1A"
    SBRB = "Br1B"
    SBRC = "Br1C"
    BP = "P1"
    BQ = "Q1"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "2.403 [MW]"
    Q = "-1.519 [MVAR]"
    }
   0.source3R([1116,522],2,0,430)
    {
    Name = "Source2"
    MVA = "100.0 [MVA]"
    Vm = "230.0 [kV]"
    F = "$(f)"
    Tc = "0.05 [s]"
    Ideal = "0"
    ZSeq = "1"
    Imp = "1"
    View = "1"
    details = "1"
    Z1 = "52.9 [ohm]"
    Phi1 = "80.0 [deg]"
    R1p = "1.0 [ohm]"
    X1p = "0.1 [ohm]"
    Z0 = "52.9 [ohm]"
    Phi0 = "80.0 [deg]"
    R0p = "1.0 [ohm]"
    X0p = "0.1 [ohm]"
    P = "S2W"
    Q = "S2Q"
    Ia = ""
    Ib = ""
    Ic = ""
    }
   0.datalabel([1044,612],0,0,-1)
    {
    Name = "F3"
    }
   0.datalabel([1044,594],0,0,-1)
    {
    Name = "FT3"
    }
   -Wire-([1962,486],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1962,522],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1962,558],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2034,450],2,0,-1)
    {
    Name = "VPM"
    }
   0.datalabel([2070,450],2,0,-1)
    {
    Name = "VNM"
    }
   0.datalabel([2106,450],2,0,-1)
    {
    Name = "VZM"
    }
   0.datalabel([2178,486],6,0,-1)
    {
    Name = "VPP"
    }
   -Wire-([2178,486],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([2178,522],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   0.datalabel([2178,558],6,0,-1)
    {
    Name = "VZP"
    }
   -Wire-([2178,558],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([1674,486],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1674,522],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1674,558],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1746,450],2,0,-1)
    {
    Name = "IPM"
    }
   0.datalabel([1782,450],2,0,-1)
    {
    Name = "INM"
    }
   0.datalabel([1818,450],2,0,-1)
    {
    Name = "IZM"
    }
   0.datalabel([1890,486],6,0,-1)
    {
    Name = "IPP"
    }
   -Wire-([1890,486],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   0.datalabel([1890,522],6,0,-1)
    {
    Name = "INP"
    }
   -Wire-([1890,522],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   0.datalabel([1890,558],6,0,-1)
    {
    Name = "IZP"
    }
   -Wire-([1890,558],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   0.datalabel([2178,522],6,0,-1)
    {
    Name = "VNP"
    }
   0.datalabel([1962,486],2,0,-1)
    {
    Name = "V1a"
    }
   0.datalabel([1962,558],2,0,-1)
    {
    Name = "v1c"
    }
   0.datalabel([1962,522],2,0,-1)
    {
    Name = "V1b"
    }
   0.datalabel([1674,486],2,0,-1)
    {
    Name = "I1a"
    }
   0.datalabel([1674,522],2,0,-1)
    {
    Name = "I1b"
    }
   0.datalabel([1674,558],2,0,-1)
    {
    Name = "I1c"
    }
   0.datatap([1746,198],3,0,650)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1746,306],3,0,590)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1692,324],2,0,-1)
    {
    Name = "IPM"
    }
   -Wire-([1692,270],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1692,270],2,0,-1)
    {
    Name = "VPP"
    }
   0.datatap([1746,342],3,0,570)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1692,360],2,0,-1)
    {
    Name = "IPP"
    }
   -Wire-([1692,216],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1746,198],6,0,-1)
    {
    Name = "Va1mag1"
    }
   0.datalabel([1692,216],2,0,-1)
    {
    Name = "VPM"
    }
   0.datalabel([1746,252],6,0,-1)
    {
    Name = "Va1Phase60"
    }
   -Wire-([1746,198],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1692,324],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1692,360],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datatap([1746,252],3,0,620)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1746,252],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1746,342],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1746,306],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.pgb([1800,306],0,40699400,1170)
    {
    Name = "Ia1Mag"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "3.0"
    }
   0.datalabel([1746,342],6,0,-1)
    {
    Name = "Ia1phase60"
    }
   0.pgb([1800,342],0,40701896,1150)
    {
    Name = "Ia1Ph"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "deg"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "200.0"
    }
   0.datatap([1962,198],3,0,640)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1962,306],3,0,580)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1962,342],3,0,550)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1908,216],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1962,198],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1908,324],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1908,360],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datatap([1962,252],3,0,610)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1962,252],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1962,342],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1962,306],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([1908,216],2,0,-1)
    {
    Name = "VnM"
    }
   0.datalabel([1908,270],2,0,-1)
    {
    Name = "VnP"
    }
   0.datalabel([1908,324],2,0,-1)
    {
    Name = "InM"
    }
   0.datalabel([1908,360],2,0,-1)
    {
    Name = "InP"
    }
   0.datalabel([1962,198],6,0,-1)
    {
    Name = "Vb1mag1"
    }
   0.datalabel([1962,252],6,0,-1)
    {
    Name = "Vb1Phase60"
    }
   0.datalabel([1962,306],6,0,-1)
    {
    Name = "Ib1mag1"
    }
   0.datalabel([1962,342],6,0,-1)
    {
    Name = "Ib1phase60"
    }
   0.pgb([2016,342],0,40719064,1130)
    {
    Name = "Ib1Ph"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "deg"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "200.0"
    }
   0.datatap([2178,198],3,0,630)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([2124,270],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datatap([2178,342],3,0,540)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([2124,216],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2178,198],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2124,324],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2124,360],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datatap([2178,252],3,0,600)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([2178,252],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2178,342],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([2178,306],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([2124,216],2,0,-1)
    {
    Name = "VZM"
    }
   0.datalabel([2124,270],2,0,-1)
    {
    Name = "VZP"
    }
   0.datalabel([2124,324],2,0,-1)
    {
    Name = "IZM"
    }
   0.datalabel([2124,360],2,0,-1)
    {
    Name = "IZP"
    }
   0.datalabel([2178,198],6,0,-1)
    {
    Name = "VC1mag1"
    }
   0.datalabel([2178,252],6,0,-1)
    {
    Name = "Vc1Phase60"
    }
   0.pgb([2214,252],0,40728600,1180)
    {
    Name = "Vc1Ph"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "deg"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "200.0"
    }
   0.datalabel([2178,306],6,0,-1)
    {
    Name = "Ic1mag1"
    }
   0.datalabel([2178,342],6,0,-1)
    {
    Name = "Ic1phase60"
    }
   0.pgb([2232,342],0,40731840,1120)
    {
    Name = "Ic1Ph"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "deg"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "200.0"
    }
   0.datalabel([1746,306],6,0,-1)
    {
    Name = "Ia1mag1"
    }
   0.pgb([1998,198],0,40734408,1220)
    {
    Name = "Vb1Mag"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "1.0"
    }
   0.datatap([2178,306],3,0,560)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.pgb([2016,306],0,40737016,1160)
    {
    Name = "Ib1Mag"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "3.0"
    }
   0.pgb([1782,252],0,40739008,1200)
    {
    Name = "Va1Ph"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "deg"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "200.0"
    }
   0.pgb([2214,198],0,40741000,1210)
    {
    Name = "Vc1Mag"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "1.0"
    }
   -Wire-([1908,270],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.pgb([2232,306],0,40743424,1140)
    {
    Name = "Ic1Mag"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "3.0"
    }
   0.fft([1782,522],0,0,520)
    {
    Type = "3"
    Size = "0"
    F = "$(f)"
    AMod = "0"
    PMod = "1"
    PModCS = "2"
    Filt = "1"
    Track = "0"
    Enab = "1"
    Fout = ""
    }
   0.fft([2070,522],0,0,440)
    {
    Type = "3"
    Size = "0"
    F = "$(f)"
    AMod = "0"
    PMod = "1"
    PModCS = "2"
    Filt = "1"
    Track = "0"
    Enab = "1"
    Fout = ""
    }
   0.pgb([1998,252],0,40746824,1190)
    {
    Name = "Vb1Ph"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "deg"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "200.0"
    }
   0.pgb([1782,198],0,40748816,1230)
    {
    Name = "Va1Mag"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "1.0"
    }
   -Wire-([864,522],0,0,-1)
    {
    Vertex="0,0;-90,0"
    }
   -Wire-([486,522],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.tpflt([1080,576],4,0,1090)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   -Wire-([702,846],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.varrlc([720,846],7,0,1010)
    {
    RLC = "0"
    R = "RfaultC"
    L = "1.0 [H]"
    C = "1.0 [uF]"
    E = "0.0 [kV]"
    I = ""
    }
   0.tpflt([486,630],0,0,1100)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   -Wire-([612,882],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   -Wire-([1062,522],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   0.Sequencer_Start([162,1026],0,0,70)
    {
    loop = "0"
    State = "1"
    }
   -Wire-([630,720],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([684,720],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.ground([666,882],1,0,-1)
    {
    }
   0.varrlc([666,846],1,0,1020)
    {
    RLC = "0"
    R = "RfaultB"
    L = "1.0 [H]"
    C = "1.0 [uF]"
    E = "0.0 [kV]"
    I = ""
    }
   0.varrlc([612,846],1,0,1030)
    {
    RLC = "0"
    R = "Rfaulta"
    L = "1.0 [H]"
    C = "1.0 [uF]"
    E = "0.0 [kV]"
    I = ""
    }
   -Wire-([630,612],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([576,648],0,0,-1)
    {
    Vertex="0,0;0,180"
    }
   -Wire-([576,828],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([612,828],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([630,648],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   -Wire-([702,612],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([702,648],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([756,828],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   -Wire-([702,828],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([756,648],0,0,-1)
    {
    Vertex="0,0;0,180"
    }
   -Wire-([666,774],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([666,774],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   0.varrlc([684,720],4,0,1040)
    {
    RLC = "0"
    R = "Rpar"
    L = "1.0 [H]"
    C = "1.0 [uF]"
    E = "0.0 [kV]"
    I = ""
    }
   0.Sequencer_SetVar([270,1026],0,0,80)
    {
    Variable = "Rfaulta"
    VarType = "0"
    RValue = "1000000"
    IValue = "1"
    State = "1"
    }
   0.Sequencer_SetVar([378,1026],0,0,90)
    {
    Variable = "Rfaultb"
    VarType = "0"
    RValue = "1000000"
    IValue = "1"
    State = "1"
    }
   0.Sequencer_SetVar([486,1026],0,0,100)
    {
    Variable = "Rfaultc"
    VarType = "0"
    RValue = "1000000"
    IValue = "1"
    State = "1"
    }
   0.Sequencer_Wait([702,1026],0,0,120)
    {
    WaitType = "0"
    CrossDir = "1"
    FixedDelay = "0.2 [s]"
    Min = "0.0 [s]"
    Max = "1.0 [s]"
    UntilTime = "1.0 [s]"
    CrossValue = "0.0"
    CrossSig = "VA"
    State = "1"
    }
   0.Sequencer_SetVar([810,1026],0,0,130)
    {
    Variable = "Rfaulta"
    VarType = "0"
    RValue = "100"
    IValue = "1"
    State = "1"
    }
   0.Sequencer_Wait([918,1026],0,0,140)
    {
    WaitType = "0"
    CrossDir = "1"
    FixedDelay = "0.1 [s]"
    Min = "0.0 [s]"
    Max = "1.0 [s]"
    UntilTime = "1.0 [s]"
    CrossValue = "0.0"
    CrossSig = "VA"
    State = "1"
    }
   0.Sequencer_SetVar([1026,1026],0,0,150)
    {
    Variable = "Rfaulta"
    VarType = "0"
    RValue = "0.001"
    IValue = "1"
    State = "1"
    }
   0.Sequencer_SetVar([594,1026],0,0,110)
    {
    Variable = "rpar"
    VarType = "0"
    RValue = "1000000"
    IValue = "1"
    State = "1"
    }
   -Wire-([702,846],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   .Plots([1530,1062],0,0,160)
    {
    }
   -Wire-([792,630],0,0,-1)
    {
    Vertex="0,0;0,144"
    }
   -Wire-([666,630],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   0.breakout([666,576],1,0,-1)
    {
    Dis = "0"
    }
   -Wire-([630,720],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   0.varrlc([630,666],7,0,1070)
    {
    RLC = "0"
    R = "Rpar"
    L = "1.0 [H]"
    C = "1.0 [uF]"
    E = "0.0 [kV]"
    I = ""
    }
   -Wire-([630,648],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([702,720],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   0.varrlc([702,666],7,0,1050)
    {
    RLC = "0"
    R = "rpar"
    L = "1.0 [H]"
    C = "1.0 [uF]"
    E = "0.0 [kV]"
    I = ""
    }
   -Wire-([702,648],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([666,630],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   .Controls([1476,1062],4,0,470)
    {
    }
   -Wire-([504,522],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   -Sticky-([216,396],0)
    {
    Name = ""
    Font = 1
    Bounds = 216,396,306,432
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "SUBSTATION 1"
    }
   -Sticky-([18,18],0)
    {
    Name = ""
    Font = 1
    Bounds = 18,18,594,288
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
Description: 
- Two Thevinen Impedance sources connected via one 100km transmission line
   divide into 2 line sections, T1 and T2.
- System voltage is 230kV settable via source equivalents.
- Simulates two substations connected via one transmission line.
- Five fault positions for full fault control ahead and behind station relays and Mid line
- Two breakers are independently timed controlled. (Default is closed).
- Independent breaker pole tripping is possible.

 This case demonstrates use of Sequence controls for an evolving fault. The Fault A  impedance is set to 100
 ohm at t=0.2  sec and then 100ms later it is decreased to 0.001 ohm.   A  phase to phase  or line to line fault could
simulated using similiar techniques. "
    }
   -Sticky-([1116,630],0)
    {
    Name = ""
    Font = 1
    Bounds = 1116,630,1206,666
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "SUBSTATION 2"
    }
   -Sticky-([684,36],0)
    {
    Name = ""
    Font = 1
    Bounds = 684,36,1080,144
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
This case uses global substitutions.  To change between 50Hz/60Hz, select Global Substitutions (Ctrl-G).  In the pop-up window, change the value of f to the desired frequency.
"
    }
   -Divider-([36,1134],0)
    {
    Size(1566,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   0.multimeter([468,522],0,0,10)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V1"
    P = ""
    Q = ""
    Vrms = "V1rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.multimeter([882,522],4,0,20)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V2"
    P = ""
    Q = ""
    Vrms = "V2rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.datalabel([1278,1260],0,0,-1)
    {
    Name = "V1rms"
    }
   -Wire-([1278,1260],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1404,1260],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1404,1260],0,0,-1)
    {
    Name = "V2rms"
    }
   -Divider-([1602,72],0)
    {
    Size(0,1476)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Plot-([1764,630],0)
    {
    Title = "Current"
    Draw = 1
    Area = [0,0,0,0]
    Posn = [-1,-1]
    Icon = [-1,-1]
    Extents = 0,0,414,378
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,414,158],"Magnitude")
     {
     Options = 9
     Units = ""
     Curve(40699400,"Ia1Mag",0,,,)
     Curve(40737016,"Ib1Mag",1,,,)
     Curve(40743424,"Ic1Mag",2,,,)
     }
    Graph([0,158],[0,0,414,157],"Phase")
     {
     Options = 9
     Units = ""
     Curve(40701896,"Ia1Ph",0,,,)
     Curve(40719064,"Ib1Ph",1,,,)
     Curve(40731840,"Ic1Ph",2,,,)
     }
    }
   -Plot-([1764,1044],0)
    {
    Title = "Voltages"
    Draw = 1
    Area = [0,0,0,0]
    Posn = [-1,-1]
    Icon = [-1,-1]
    Extents = 0,0,414,378
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,414,158],"Magnitude")
     {
     Options = 9
     Units = ""
     Curve(40748816,"Va1Mag",0,,,)
     Curve(40734408,"Vb1Mag",1,,,)
     Curve(40741000,"Vc1Mag",2,,,)
     }
    Graph([0,158],[0,0,414,157],"Phase")
     {
     Options = 9
     Units = ""
     Curve(40739008,"Va1Ph",0,,,)
     Curve(40746824,"Vb1Ph",1,,,)
     Curve(40728600,"Vc1Ph",2,,,)
     }
    }
   0.pi_section2([666,522],0,0,-1)
    {
    Name = "Line1"
    PU = "1"
    F = "$(f)"
    len = "100.0 [km]"
    Estim = "0"
    View = "1"
    ConNeed = "1"
    Percent = "50 [%]"
    REst = "1.5"
    ZEst = "1.5"
    TEst = "1.5"
    Rp = "3.57448095e-5 [ohm/m]"
    Xp = "5.07762676e-4 [ohm/m]"
    Bp = "3.27117946e-9 [mho/m]"
    Rz = "3.63152201e-4 [ohm/m]"
    Xz = "1.32647323e-3 [ohm/m]"
    Bz = "2.32266098e-9 [mho/m]"
    VR2 = "230.0 [kV]"
    MVA2 = "100.0 [MVA]"
    RPUP2 = ".336786E-7 [pu/m]"
    XLPUP2 = ".593346E-6 [pu/m]"
    BPUP2 = "1.93387E-6 [pu/m]"
    RPUZ2 = ".558072E-6 [pu/m]"
    XLPUZ2 = ".196578E-5 [pu/m]"
    BPUZ2 = "1.27727E-6 [pu/m]"
    }
   }
  }
 }

